//	CDialogEraseDisk.c

#include "string.h"
#include "stdio.h"
#include "Utils.h"
#include "MainEvent.h"
#include "CDialog3Button.h"

#include "CDialogEraseDisk.h"

typedef struct {
	Dlog_ItemIDType			i_itemHit;
	Boolean					i_doneB;
} Dlog_EraseDiskRec;

static	Dlog_EraseDiskRec		S_deleteAnswer;

void				ResetEraseDiskDialog(Dlog_ItemIDType itemID)
{
	S_deleteAnswer.i_itemHit	= itemID;
	S_deleteAnswer.i_doneB		= itemID != kDlog_EraseDisk_ItemID_NONE;
}

static	Boolean		EraseDisk_S_CB(short buttonID, void *cbData)
{
	Dlog_EraseDiskRec		*deleteAnswerP = (Dlog_EraseDiskRec *)cbData;
	
	deleteAnswerP->i_itemHit	= buttonID;
	deleteAnswerP->i_doneB		= TRUE;
	
	return TRUE;
}

Dlog_ItemIDType		DoEraseDiskDialog(char *fileNameZ)
{
	if (!S_deleteAnswer.i_doneB) {
		CDialog3Button			*dialogP;
		Dlog3ButtonParamRec		dialogParams;
		Dlog3ButtonRec			*buttonP;
		
		strcpy(dialogParams.titleAC, "Erase Disk");
		
		sprintf(
			dialogParams.verbageAC, 
			"Are you sure you want to erase the disk %s and delete "
			"every item it contains?  You can not undo this action.", 
			fileNameZ);
		
		dialogParams.DoneCB = EraseDisk_S_CB;
		dialogParams.cbData	= &S_deleteAnswer;

		buttonP = &dialogParams.buttonA[kDlog_EraseDisk_ItemID_ERASE];
		strcpy(buttonP->nameAC, "Erase");
		buttonP->buttonID		= kDlog_3Button_ItemStr_BUTTON_1;
		buttonP->actionType		= Dlog_Action_NONE;
		buttonP->visibleB		= TRUE;
		buttonP->keyEquivChar	= 0;

		buttonP = &dialogParams.buttonA[kDlog_EraseDisk_ItemID_INVIS];
		strcpy(buttonP->nameAC, "");
		buttonP->buttonID		= kDlog_3Button_ItemStr_BUTTON_2;
		buttonP->actionType		= Dlog_Action_NONE;
		buttonP->visibleB		= FALSE;
		buttonP->keyEquivChar	= 0;

		buttonP = &dialogParams.buttonA[kDlog_EraseDisk_ItemID_CANCEL];
		strcpy(buttonP->nameAC, "Cancel");
		buttonP->buttonID		= kDlog_3Button_ItemStr_BUTTON_3;
		buttonP->actionType		= Dlog_Action_DEFAULT;
		buttonP->visibleB		= TRUE;
		buttonP->keyEquivChar	= 0;
		
		dialogP = Show3ButtonDialog(&dialogParams);
		if (dialogP) {
			do {
				HandleOneEvent(10);
			} while (!S_deleteAnswer.i_doneB);
			
			//	already disposed;
			//	dialogP->Dispose();
		}
	}
	
	return S_deleteAnswer.i_itemHit;
}
